in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D textureSampler;

void main()
{
    vec2 textureCoords = vec2(texCoord.x, 1.0 - texCoord.y);

    vec4 color1 = texture(textureSampler, textureCoords);
    vec4 color2 = texture(textureSampler, textureCoords + vec2(1.0 / 512.0, 0.0));
    vec4 color3 = texture(textureSampler, textureCoords + vec2(0.0, 1.0 / 512.0));
    vec4 color4 = texture(textureSampler, textureCoords + vec2(1.0 / 512.0, 1.0 / 512.0));

    vec4 finalColor = vec4(0.0);
    finalColor.rgb = (color1.rgb * 4.0 + color2.rgb * 2.0 + color3.rgb * 2.0 + color4.rgb) / 9.0;
    finalColor.a = 1.0;

    fragColor = finalColor;
}
